/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.meta;

import io.github.noeppi_noeppi.libx.annotation.meta.RemoveIn;
import io.github.noeppi_noeppi.libx.annotation.processor.ExternalProperties;
import io.github.noeppi_noeppi.libx.annotation.processor.Processor;
import io.github.noeppi_noeppi.libx.annotation.processor.meta.ArtifactVersion;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class RemoveInProcessor
extends Processor {
    @Override
    public Class<?>[] getTypes() {
        return new Class[]{RemoveIn.class};
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(RemoveIn.class)) {
            ArtifactVersion modVersion;
            ArtifactVersion ver;
            ArtifactVersion minecraftVersion;
            Deprecated deprecated = element.getAnnotation(Deprecated.class);
            if (deprecated == null || !deprecated.forRemoval()) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "Elements annotated with @RemoveIn must be annotated with @Deprecated(forRemoval = true)", element);
                continue;
            }
            RemoveIn remove = element.getAnnotation(RemoveIn.class);
            if (remove.minecraft().isEmpty() && remove.mod().isEmpty()) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "@RemoveIn has no properties set.", element);
                continue;
            }
            if (!remove.minecraft().isEmpty() && (minecraftVersion = ExternalProperties.minecraftVersion(this)) != null && minecraftVersion.compareTo(ver = ArtifactVersion.parse(remove.minecraft())) >= 0) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "Element should have been removed.", element);
                continue;
            }
            if (remove.mod().isEmpty() || (modVersion = ExternalProperties.modVersion(this)) == null || modVersion.compareTo(ver = ArtifactVersion.parse(remove.mod())) <= 0) continue;
            this.messager().printMessage(Diagnostic.Kind.ERROR, "Element should have been removed.", element);
        }
    }
}

